"""Repository for application settings."""

from __future__ import annotations

from typing import Optional
from tinydb import Query

from ca_task_manager.models.settings import Settings
from ca_task_manager.repositories.base import TinyDBRepository


class SettingsRepository(TinyDBRepository):
    def __init__(self, db_path: str = "data/settings.json"):
        super().__init__(db_path, table_name="settings", model_class=Settings)

    def get_settings(self) -> Settings:
        # There should be only one settings record
        items = self.table.all()
        if items:
            return Settings(**items[0])
        # Return default settings if none exist
        default = Settings()
        self.insert(default.dict())
        return default

    def update_settings(self, settings: Settings) -> None:
        # Replace existing settings record or insert new one
        items = self.table.all()
        if items:
            self.table.update(settings.dict(), doc_ids=[items[0].doc_id])
        else:
            self.insert(settings.dict())